/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Parser;
import com.floragunn.codova.documents.patch.PatchableDocument;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.ValidatingDocNode;
import com.floragunn.codova.validation.ValidationErrors;
import com.floragunn.codova.validation.ValidationResult;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.google.common.collect.ImmutableMap;

public class FeMultiTenancyConfig
implements PatchableDocument<FeMultiTenancyConfig> {
    public static CType<FeMultiTenancyConfig> TYPE = new CType("frontend_multi_tenancy", "Frontend Multi-Tenancy", 10001, FeMultiTenancyConfig.class, FeMultiTenancyConfig::parse, CType.Storage.OPTIONAL, CType.Arity.SINGLE);
    public static final FeMultiTenancyConfig DEFAULT = new FeMultiTenancyConfig(null, true, "kibanaserver", ".kibana");
    private final DocNode source;
    private final boolean enabled;
    private final String index;
    private final String serverUsername;

    FeMultiTenancyConfig(DocNode source, boolean enabled, String serverUsername, String index) {
        this.source = source;
        this.enabled = enabled;
        this.serverUsername = serverUsername;
        this.index = index;
    }

    public static ValidationResult<FeMultiTenancyConfig> parse(DocNode docNode, Parser.Context context) {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors, context);
        boolean enabled = vNode.get("enabled").withDefault(true).asBoolean();
        String index = vNode.get("index").withDefault(DEFAULT.getIndex()).asString();
        String serverUsername = vNode.get("server_user").withDefault(DEFAULT.getServerUsername()).asString();
        return new ValidationResult((Object)new FeMultiTenancyConfig(docNode, enabled, serverUsername, index), validationErrors);
    }

    public static FeMultiTenancyConfig parseLegacySgConfig(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        ValidationErrors validationErrors = new ValidationErrors();
        ValidatingDocNode vNode = new ValidatingDocNode(docNode, validationErrors);
        boolean enabled = vNode.get("dynamic.kibana.multitenancy_enabled").withDefault(true).asBoolean();
        String index = vNode.get("dynamic.kibana.index").withDefault(DEFAULT.getIndex()).asString();
        String serverUsername = vNode.get("dynamic.kibana.server_username").withDefault(DEFAULT.getServerUsername()).asString();
        validationErrors.throwExceptionForPresentErrors();
        return new FeMultiTenancyConfig(null, enabled, serverUsername, index);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getIndex() {
        return this.index;
    }

    public String getServerUsername() {
        return this.serverUsername;
    }

    public Object toBasicObject() {
        if (this.source != null) {
            return this.source;
        }
        return ImmutableMap.of((Object)"enabled", (Object)this.enabled, (Object)"index", (Object)this.index, (Object)"server_user", (Object)this.serverUsername);
    }

    public String toString() {
        return "FeMultiTenancyConfig [source=" + this.source + ", enabled=" + this.enabled + ", index=" + this.index + ", serverUsername=" + this.serverUsername + "]";
    }

    public FeMultiTenancyConfig parseI(DocNode docNode, Parser.Context context) throws ConfigValidationException {
        return (FeMultiTenancyConfig)FeMultiTenancyConfig.parse(docNode, (Parser.Context)((ConfigurationRepository.Context)context)).get();
    }
}

